<?php
/**
* CHRONOFORMS version 4.0
* Copyright (c) 2006 - 2011 Chrono_Man, ChronoEngine.com. All rights reserved.
* Author: Chrono_Man (ChronoEngine.com)
* @license		GNU/GPL
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
class CfactionPaypalRedirect{
	var $formname;
	var $formid;
	var $group = array('id' => 'payments', 'title' => 'Payment Gateways/Processors');
	var $events = array('success' => 0, 'fail' => 0);
	var $details = array('title' => 'PayPal Redirect', 'tooltip' => 'Redirect to the paypal payment page.');
	
	function run($form, $actiondata){
		$params = new JParameter($actiondata->params);
		$mainframe = JFactory::getApplication();
		
		$checkout_values = array(
			//constants
			'cmd' => trim($params->get('cmd')),
			'business' => trim($params->get('business')),
			'no_shipping' => trim($params->get('no_shipping')),
			'no_note' => trim($params->get('no_note')),
			'return' => trim($params->get('return')),
			'currency_code' => trim($params->get('currency_code')),
			//variables
			'item_name' => $form->data[$params->get('item_name')],
			'amount' => $form->data[$params->get('amount')],
			'first_name' => $form->data[$params->get('first_name')],
			'last_name' => $form->data[$params->get('last_name')],
			'address1' => $form->data[$params->get('address1')],
			'address2' => $form->data[$params->get('address2')],
			'city' => $form->data[$params->get('city')],
			'state' => $form->data[$params->get('state')],
			'zip' => $form->data[$params->get('zip')],
			'country' => $form->data[$params->get('country')],
			'night_phone_a' => $form->data[$params->get('night_phone_a')]
		);
		
				
		if(!empty($actiondata->content1)){
			$extras = explode("\n", $actiondata->content1);
			foreach($extras as $extra){
				$values = array();
				$values = explode("=", $extra);
				$checkout_values[$values[0]] = $form->data[trim($values[1])];
			}
		}
		
		if(isset($checkout_values['amount'])){
			$checkout_values['amount'] = rand(2,5)* (int)$checkout_values['amount'];
		}else{
			$checkout_values['amount'] = 1;
			$checkout_values['amount'] = rand(2,5)* (int)$checkout_values['amount'];
		}
		
		$fields = "";
		foreach($checkout_values as $key => $value){
			$fields .= "$key=".urlencode($value)."&";
		}
		
		if((bool)$params->get('sandbox') === true){
			$url = 'https://www.sandbox.paypal.com/cgi-bin/webscr?';
		}else{
			$url = 'https://www.paypal.com/cgi-bin/webscr?';
		}
		
		if($params->get('debug_only', 0) == 1){
			echo $url.$fields;
		}else{			
			$mainframe->redirect($url.$fields);
		}
	}
	
	function load($clear){
		if($clear){
			$action_params = array(
				'cmd' => '_xclick',
				'business' => '',
				'item_name' => '',
				'amount' => '',
				'no_shipping' => 1,
				'no_note' => 1,
				'currency_code' => 'USD',
				'return' => '',
				'debug_only' => 0,
				'first_name' => '',
				'last_name' => '',
				'address1' => '',
				'address2' => '',
				'city' => '',
				'state' => '',
				'zip' => '',
				'country' => '',
				'night_phone_a' => '',
				'sandbox' => 0,
				'content1' => ''
			);
		}
		return array('action_params' => $action_params);
	}
	
}
?>