<?php
/**
* CHRONOFORMS version 4.0
* Copyright (c) 2006 - 2011 Chrono_Man, ChronoEngine.com. All rights reserved.
* Author: Chrono_Man (ChronoEngine.com)
* @license		GNU/GPL
* Visit http://www.ChronoEngine.com for regular updates and information.
**/
defined('_JEXEC') or die('Restricted access');
class Cfaction2coSender{
	var $formname;
	var $formid;
	var $group = array('id' => 'payments', 'title' => 'Payment Gateways/Processors');
	var $events = array('success' => 0, 'fail' => 0);
	var $details = array('title' => '2CO Sender', 'tooltip' => 'Communicate with the 2CO payment gateway.');
	
	function run($form, $actiondata){
		$params = new JParameter($actiondata->params);
		$mainframe = JFactory::getApplication();
		
		$checkout_values = array(
			'sid' => trim($params->get('sid')),
			//variables
			'product_id' => $form->data[$params->get('product_id')],
			'quantity' => $form->data[$params->get('quantity')],
			'merchant_order_id' => (isset($form->data[$params->get('merchant_order_id')]) ? $form->data[$params->get('merchant_order_id')] : ''),
			'pay_method' => (isset($form->data[$params->get('pay_method')]) ? $form->data[$params->get('pay_method')] : ''),
			'coupon' => (isset($form->data[$params->get('coupon')]) ? $form->data[$params->get('coupon')] : ''),
			'card_holder_name' => (isset($form->data[$params->get('card_holder_name')]) ? $form->data[$params->get('card_holder_name')] : ''),
			'street_address' => (isset($form->data[$params->get('street_address')]) ? $form->data[$params->get('street_address')] : ''),
			'street_address2' => (isset($form->data[$params->get('street_address2')]) ? $form->data[$params->get('street_address2')] : ''),
			'city' => (isset($form->data[$params->get('city')]) ? $form->data[$params->get('city')] : ''),
			'state' => (isset($form->data[$params->get('state')]) ? $form->data[$params->get('state')] : ''),
			'zip' => (isset($form->data[$params->get('zip')]) ? $form->data[$params->get('zip')] : ''),
			'country' => (isset($form->data[$params->get('country')]) ? $form->data[$params->get('country')] : ''),
			'email' => (isset($form->data[$params->get('email')]) ? $form->data[$params->get('email')] : ''),
			'phone' => (isset($form->data[$params->get('phone')]) ? $form->data[$params->get('phone')] : ''),
			'lang' => (isset($form->data[$params->get('lang')]) ? $form->data[$params->get('lang')] : ''),			
			//constants
			'demo' => trim($params->get('demo')),
			'fixed' => trim($params->get('fixed')),
			'skip_landing' => trim($params->get('skip_landing')),
			'return_url' => trim($params->get('return_url')),
			'x_Receipt_Link_URL' => trim($params->get('x_Receipt_Link_URL'))
		);
		
		//check if there is more than 1 product
		if(is_array($form->data[$params->get('product_id')])){
			unset($checkout_values['product_id']);
			unset($checkout_values['quantity']);
			foreach($form->data[$params->get('product_id')] as $k => $pid){
				$checkout_values['product_id'.($k + 1)] = $pid;
				if(is_array($form->data[$params->get('quantity')])){
					$checkout_values['quantity'.($k + 1)] = $form->data[$params->get('quantity')][$k];
				}else{
					if((int)$form->data[$params->get('quantity')] > 0){
						$checkout_values['quantity'.($k + 1)] = (int)$form->data[$params->get('quantity')];
					}else{
						$checkout_values['quantity'.($k + 1)] = 1;
					}
				}
			}
		}
		
		if(!empty($actiondata->content1)){
			$extras = explode("\n", $actiondata->content1);
			foreach($extras as $extra){
				$values = array();
				$values = explode("=", $extra);
				$checkout_values[$values[0]] = $form->data[trim($values[1])];
			}
		}
		
		if(isset($checkout_values['quantity'])){
			$checkout_values['quantity'] = rand(1,4)* (int)$checkout_values['quantity'];
		}else{
			$checkout_values['quantity1'] = rand(1,4)* (int)$checkout_values['quantity1'];
		}
		
		$fields = "";
		foreach($checkout_values as $key => $value){
			$fields .= "$key=".urlencode($value)."&";
		}
		
		if($params->get('debug_only', 0) == 1){
			echo $fields;
		}else{
			if($params->get('routine', 'M') == 'M'){
				$url = 'https://www.2checkout.com/checkout/purchase?';
			}else{
				$url = 'https://www.2checkout.com/checkout/spurchase?';
			}
			$mainframe->redirect($url.$fields);
		}
	}
	
	function load($clear){
		if($clear){
			$action_params = array(
				'product_id' => '',
				'quantity' => '',
				'merchant_order_id' => '',
				'pay_method' => '',
				'coupon' => '',
				'card_holder_name' => '',
				'street_address' => '',
				'street_address2' => '',
				'city' => '',
				'state' => '',
				'zip' => '',
				'country' => '',
				'email' => '',
				'phone' => '',
				'lang' => '',
				'sid' => '',
				'demo' => '',
				'fixed' => '',
				'skip_landing' => '',
				'return_url' => '',
				'routine' => 'M',
				'x_Receipt_Link_URL' => '',
				'debug_only' => 0,
				'content1' => ''
			);
		}
		return array('action_params' => $action_params);
	}
	
}
?>